import de.looksgood.ani.*;
import de.looksgood.ani.easing.*;
import processing.video.*;
import blobDetection.*;

int currentNumber = 0;
float globalTweenX = 0;
float globalTweenY = 1.0;
Ani aX, aY;
ArrayList<Digit> Digits = new ArrayList();
String numString = "0";
int countDownTimer = 0;
int lastBlobNumber = 0;

//camera stuff
Capture cam;
BlobDetection theBlobDetection;
PImage img;
boolean newFrame=false;

void setup() {
  size(displayWidth, displayHeight, P3D);

  noCursor();

  Ani.init(this);

  cam = new Capture(this, 40*4, 30*4, 15);
  cam.start();
  img = new PImage(80, 60); 
  theBlobDetection = new BlobDetection(img.width, img.height);
  theBlobDetection.setPosDiscrimination(true);
  theBlobDetection.setThreshold(0.05f);

  aX = new Ani(this, random(3.0, 20.0), "globalTweenX", 15, Ani.SINE_IN_OUT, "onStart:itsStarted, onEnd:itsEnded");
  aY = new Ani(this, random(3.0, 20.0), "globalTweenY", 0.6, Ani.SINE_IN_OUT, "onStart:itsStarted, onEnd:itsEndedY");
  aX.start();
  aY.setPlayMode(Ani.YOYO);
  aY.repeat();

  for (int d = 0; d < 10; d++) {
    Digits.add(new Digit(str(d), 60));
  }
}

void captureEvent(Capture cam)
{
  cam.read();
  newFrame = true;
}

void draw() {
  //if (cam.available() == true) {cam.read();} //image(cam, 0, 0);

  background(255);

  if (newFrame)
  {
    countDownTimer++;
    println(countDownTimer);
    newFrame=false;
    img.copy(cam, 0, 0, cam.width, cam.height, 0, 0, img.width, img.height);
    fastblur(img, 2);
    theBlobDetection.computeBlobs(img.pixels);
    
    int blobs = theBlobDetection.getBlobNb();
    
    if (blobs > 1 && blobs != lastBlobNumber) {
      lastBlobNumber = blobs;
      countUp();
    }
    
    if (countDownTimer >= 100) {
      countDownTimer = 0;
      countDown();
    }
  }

  translate(width/2, height/2);
  translate((-65 * (numString.length() - 1)), 0);
  scale(globalTweenY);

  for (int d = 0; d < numString.length(); d++) {
    int i = (int(str(numString.charAt(d))));
    Digits.get(i).display((130 * d) + globalTweenX, 0);
  }
}

void mousePressed() {
  countUp();
}

void countUp() {
  currentNumber++;
  numString = nf(currentNumber, 0);
}

void countDown() {
  currentNumber--;
  if (currentNumber < 0) {
    currentNumber = 0;
  }
  numString = nf(currentNumber, 0);
}


void itsStarted() {
}

void itsEnded(Ani theAni) {
  float end = theAni.getEnd();
  theAni.setDuration(random(3.0, 20.0));
  theAni.setBegin(end);
  theAni.setEnd(end * -1);
  theAni.start();
}

void itsEndedY(Ani theAni) {
  float end = theAni.getEnd();
  theAni.setDuration(random(3.0, 20.0));
  theAni.setBegin(0.6);
  theAni.setEnd(1.0);
  theAni.start();
}


//cam functions

void drawBlobsAndEdges(boolean drawBlobs, boolean drawEdges)
{
  noFill();
  Blob b;
  EdgeVertex eA, eB;
  for (int n=0 ; n<theBlobDetection.getBlobNb() ; n++)
  {
    b=theBlobDetection.getBlob(n);
    if (b!=null)
    {
      // Edges
      if (drawEdges)
      {
        strokeWeight(3);
        stroke(0, 255, 0);
        for (int m=0;m<b.getEdgeNb();m++)
        {
          eA = b.getEdgeVertexA(m);
          eB = b.getEdgeVertexB(m);
          if (eA !=null && eB !=null)
            line(
            eA.x*cam.width, eA.y*cam.height, 
            eB.x*cam.width, eB.y*cam.height
              );
        }
      }

      // Blobs
      if (drawBlobs)
      {
        strokeWeight(1);
        stroke(255, 0, 0);
        rect(
        b.xMin*cam.width, b.yMin*cam.height, 
        b.w*cam.width, b.h*cam.height
          );
      }
    }
  }
}

void fastblur(PImage img, int radius)
{
  if (radius<1) {
    return;
  }
  int w=img.width;
  int h=img.height;
  int wm=w-1;
  int hm=h-1;
  int wh=w*h;
  int div=radius+radius+1;
  int r[]=new int[wh];
  int g[]=new int[wh];
  int b[]=new int[wh];
  int rsum, gsum, bsum, x, y, i, p, p1, p2, yp, yi, yw;
  int vmin[] = new int[max(w, h)];
  int vmax[] = new int[max(w, h)];
  int[] pix=img.pixels;
  int dv[]=new int[256*div];
  for (i=0;i<256*div;i++) {
    dv[i]=(i/div);
  }

  yw=yi=0;

  for (y=0;y<h;y++) {
    rsum=gsum=bsum=0;
    for (i=-radius;i<=radius;i++) {
      p=pix[yi+min(wm, max(i, 0))];
      rsum+=(p & 0xff0000)>>16;
      gsum+=(p & 0x00ff00)>>8;
      bsum+= p & 0x0000ff;
    }
    for (x=0;x<w;x++) {

      r[yi]=dv[rsum];
      g[yi]=dv[gsum];
      b[yi]=dv[bsum];

      if (y==0) {
        vmin[x]=min(x+radius+1, wm);
        vmax[x]=max(x-radius, 0);
      }
      p1=pix[yw+vmin[x]];
      p2=pix[yw+vmax[x]];

      rsum+=((p1 & 0xff0000)-(p2 & 0xff0000))>>16;
      gsum+=((p1 & 0x00ff00)-(p2 & 0x00ff00))>>8;
      bsum+= (p1 & 0x0000ff)-(p2 & 0x0000ff);
      yi++;
    }
    yw+=w;
  }

  for (x=0;x<w;x++) {
    rsum=gsum=bsum=0;
    yp=-radius*w;
    for (i=-radius;i<=radius;i++) {
      yi=max(0, yp)+x;
      rsum+=r[yi];
      gsum+=g[yi];
      bsum+=b[yi];
      yp+=w;
    }
    yi=x;
    for (y=0;y<h;y++) {
      pix[yi]=0xff000000 | (dv[rsum]<<16) | (dv[gsum]<<8) | dv[bsum];
      if (x==0) {
        vmin[y]=min(y+radius+1, hm)*w;
        vmax[y]=max(y-radius, 0)*w;
      }
      p1=x+vmin[y];
      p2=x+vmax[y];

      rsum+=r[p1]-r[p2];
      gsum+=g[p1]-g[p2];
      bsum+=b[p1]-b[p2];

      yi+=w;
    }
  }
}

